---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：91-Declarative Pipelines

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：設定パラメータの記述は確認できるがデフォルト値の検証が不完全
  2. **セキュリティ考慮事項**：カタログレベル依存の記述は推論に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/elements.scala`
- E-02: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/Flow.scala`
- E-03: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/DataflowGraph.scala`
- E-04: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphRegistrationContext.scala`
- E-05: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/PipelineExecution.scala`
- E-06: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/TriggeredGraphExecution.scala`
- E-07: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/GraphExecution.scala`
- E-08: `sql/pipelines/src/main/scala/org/apache/spark/sql/pipelines/graph/DatasetManager.scala`
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル・ビュー・フローの宣言的登録 | E-04 (registerTable/registerView/registerFlow) | ○ |
| C-02 | DataflowGraphによるグラフ構造構築 | E-03 (DataflowGraph case class) | ○ |
| C-03 | トポロジカルソートによる依存関係解決 | E-03 (validateGraphIsTopologicallySorted) | ○ |
| C-04 | TriggeredGraphExecutionでのトポロジカル実行 | E-06 (topologicalExecution method) | ○ |
| C-05 | 指数バックオフ付きリトライ | E-06 (ExponentialBackoffStrategy, failureTracker) | ○ |
| C-06 | 空パイプラインでRUN_EMPTY_PIPELINEエラー | E-04 (line 73-76) | ○ |
| C-07 | PIPELINE_DUPLICATE_IDENTIFIERS.FLOWエラー | E-03 (line 76-81), E-04 (line 163-173) | ○ |
| C-08 | PIPELINE_DATASET_WITHOUT_FLOWエラー | E-03 (line 216-225) | ○ |
| C-09 | ONCEフローは1回のみ実行 | E-06 (line 232-237, IDLE state) | ○ |
| C-10 | 並行実行制限（Semaphore） | E-06 (concurrencyLimit Semaphore) | ○ |
| C-11 | StreamState状態遷移 | E-06 (StreamState object, line 454-494) | ○ |
| C-12 | DatasetManager.materializeDatasetsでテーブル作成 | E-08 (materializeDatasets method) | ○ |
| C-13 | カタログV2 APIとの連携 | E-08 (TableCatalog, Identifier usage) | ○ |
| C-14 | フルリフレッシュ時のTRUNCATE | E-08 (line 302-304) | ○ |
| C-15 | PersistedViewのマテリアライゼーション | E-08 (materializeViews method) | ○ |
| C-16 | FlowPlannerによるフロー実行計画生成 | E-07 (flowPlanner field) | ○ |
| C-17 | 下流フローのスキップ処理 | E-06 (recordSkippedIfSelected, downstreamFlows) | ○ |
| C-18 | PipelineEventコールバック | E-05 (context.eventCallback) | ○ |
| C-19 | パフォーマンス要件の具体値 | **根拠なし** | △ |
| C-20 | セキュリティ制御はカタログレベル依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: パフォーマンス要件のデフォルト値について、SQLConf定義を直接確認していない
  - 候補：SQLConf.scala / spark-defaults.conf
- C-20: セキュリティ制御の詳細はパイプラインコード内に明示的な記述がなく、推論に基づく
  - 候補：セキュリティ設計書 / カタログプロバイダの実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の記述（グラフ構造、実行制御、リトライ）は十分な根拠あり
- 1: 中リスク - パフォーマンス設定のデフォルト値の正確性要確認
- 0: 低リスク - エラー処理の記述はソースコードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] DataflowGraphのバリデーション項目が網羅されているか確認
- [ ] TriggeredGraphExecutionの状態遷移図がコードと一致するか確認
- [ ] DatasetManagerのスキーママージロジックが正確に記述されているか確認
- [ ] リトライ設定パラメータのデフォルト値を確認
